Attribute VB_Name = "mCoreTemp"
'http://www.alcpu.com/CoreTemp/developers.html

Option Explicit

Declare Function GetTempInfo Lib "GetCoreTempInfo32.dll" Alias "fnGetCoreTempInfoAlt" (ByVal pData As Long) As Byte

Public Type CoreTempData
  uiLoad(255) As Long
  uiTjMax(127) As Long
  uiCoreCnt As Long
  uiCPUCnt As Long
  fTemp(255) As Single
  fVID As Single
  fCPUSpeed As Single
  fFSBSpeed As Single
  fMultipier As Single
  sCPUname(99) As Byte
  ucFahrenheit As Byte
  ucDeltaToTjMax As Byte
End Type

Public tData As CoreTempData


Sub Main()
  Call tDebug
End Sub


Public Function tRead() As Boolean
  Dim pData As Long
  pData = VarPtr(tData) 'Pointer
  If GetTempInfo(pData) = 1 Then tRead = True
End Function


Public Function ByteArrayToString(ByteArray() As Byte) As String
  Dim B As Variant
  For Each B In ByteArray()
    If B = 0 Then Exit For
    ByteArrayToString = ByteArrayToString & Chr$(B)
  Next
End Function


Public Sub tDebug()

  Dim CntCPU As Byte
  Dim CntCore As Byte

  If tRead = True Then
    Debug.Print "Processor:  " & ByteArrayToString(tData.sCPUname)
    Debug.Print "Frequency:  " & Format(tData.fCPUSpeed, "####0.0000") & " MHz  (" & Format(tData.fFSBSpeed, "0.00") & " x " & Format(tData.fMultipier, "0.0") & ")"
    Debug.Print "VoltageID:  " & Format(tData.fVID, "0.0000") & "v"
    For CntCPU = 0 To tData.uiCPUCnt - 1
      Debug.Print " CPU #" & CntCPU & ":  ";
      Debug.Print "   Tj. Max = " & Format(tData.uiTjMax(CntCPU), "##0") & "C"
      For CntCore = 0 To tData.uiCoreCnt - 1
        Debug.Print "  CORE #" & CntCore * (CntCPU + 1) & ":   ";
        Debug.Print "Usage load = " & Format(tData.uiLoad(CntCore), "##0") & "%,  ";
        Debug.Print "Temperature = " & Format(tData.fTemp(CntCore), "##0") & "C,  ";
        Debug.Print
      Next
    Next
  Else
    Debug.Print "Error: No Data!"
  End If

End Sub

